clear
close all

%% JOLTS
JOLTS = readtable('../Data/JOLTS/JOLTS.csv');
startDate = datenum('12-01-2000');
endDate = datenum('09-01-2018');
tGrid = linspace(startDate,endDate,214)';
JOLTS.date = tGrid;

hpParam = 129600;

[~,JOLTS.QUR_cyc] = hpfilter(JOLTS.QUR,hpParam);
[~,JOLTS.HIR_cyc] = hpfilter(JOLTS.HIR,hpParam);
[~,JOLTS.JOR_cyc] = hpfilter(JOLTS.JOR,hpParam);


lineSpec1 = {'lineWidth', 1, 'lineStyle', '-' , 'Color', rgb('DarkGreen')};
lineSpec2 = {'lineWidth', 1, 'lineStyle', '--', 'Color', rgb('Navy')};
lineSpec3 = {'lineWidth', 1, 'lineStyle', '-.', 'Color', rgb('Maroon')};
lineSpec4 = {'lineWidth', 1, 'lineStyle', ':' , 'Color', rgb('Black')};
gridLineSpec = {'gridlinestyle','--'};

fontSize = 15;
latex={'Interpreter','Latex'};

graphPath = '~/Dropbox/Research/Replacement Hiring/Output/';



xLabel = 'Year';
yLabel = 'Rate (\%)';

%% *** Hiring, Quit, Job Opening Rates***
figNum = 1;

figure(figNum)
plot(tGrid,JOLTS.HIR,lineSpec1{:})
hold on
plot(tGrid,JOLTS.JOR,lineSpec2{:})
plot(tGrid,JOLTS.QUR,lineSpec3{:})
hold off
datetick('x','yy')
legend('Hires (JOLTS)','Job Openings (JOLTS)','Quits (JOLTS)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'JOLTS_HIR_JOR_QUR'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Hires and Jop Openings ***
figure(figNum)
plot(JOLTS.date,JOLTS.HIR_cyc,lineSpec1{:})
hold on
plot(JOLTS.date,JOLTS.QUR_cyc,lineSpec2{:})
hold off
datetick('x','yy')
legend('Hires (JOLTS)','Quits (JOLTS)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'JOLTS_HIR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Quits and Jop Openings ***
figure(figNum)
plot(JOLTS.date,JOLTS.JOR_cyc,lineSpec1{:})
hold on
plot(JOLTS.date,JOLTS.QUR_cyc,lineSpec2{:})
hold off
datetick('x','yy')
legend('Jop Openings (JOLTS)','Quits (JOLTS)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'JOLTS_JOR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;

